/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CatwalkBlock
extends Block
implements IWrenchable,
SimpleWaterloggedBlock {
    private static final VoxelShape VOXEL_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape VOXEL_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape VOXEL_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape VOXEL_EAST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape VOXEL_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final BooleanProperty NORTH_FENCE = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH_FENCE = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST_FENCE = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST_FENCE = BlockStateProperties.f_61371_;
    public static final BooleanProperty LIFTED = BlockStateProperties.f_61427_;

    private static boolean hasNeighborTo(Direction side, BlockPlaceContext ctx) {
        return ctx.m_43725_().m_8055_(ctx.m_8083_().m_141952_(side.m_122436_())).m_60734_() instanceof CatwalkBlock;
    }

    public CatwalkBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST_FENCE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST_FENCE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIFTED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return this.m_6079_(state, reader, pos);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter world, BlockPos pos) {
        VoxelShape shape = VOXEL_BOTTOM;
        if (((Boolean)state.m_61143_((Property)NORTH_FENCE)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)VOXEL_NORTH, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH_FENCE)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)VOXEL_SOUTH, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)EAST_FENCE)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)VOXEL_EAST, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)WEST_FENCE)).booleanValue()) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)VOXEL_WEST, (BooleanOp)BooleanOp.f_82695_);
        }
        return shape.m_83216_(0.0, (Boolean)state.m_61143_((Property)BlockStateProperties.f_61427_) != false ? 0.0 : -0.125, 0.0);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world;
        Direction facing = ctx.m_8125_();
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        boolean lift = ctx.m_43720_().f_82480_ - (double)ctx.m_8083_().m_123342_() < 0.5;
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIFTED, (Comparable)Boolean.valueOf(lift))).m_61124_((Property)NORTH_FENCE, (Comparable)Boolean.valueOf(facing == Direction.NORTH && !CatwalkBlock.hasNeighborTo(Direction.NORTH, ctx)))).m_61124_((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf(facing == Direction.SOUTH && !CatwalkBlock.hasNeighborTo(Direction.SOUTH, ctx)))).m_61124_((Property)EAST_FENCE, (Comparable)Boolean.valueOf(facing == Direction.EAST && !CatwalkBlock.hasNeighborTo(Direction.EAST, ctx)))).m_61124_((Property)WEST_FENCE, (Comparable)Boolean.valueOf(facing == Direction.WEST && !CatwalkBlock.hasNeighborTo(Direction.WEST, ctx)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        if (!lift && CatwalkBlock.canPlaceCatwalk(world = ctx.m_43725_(), ctx.m_8083_().m_142082_(0, 1, 0))) {
            world.m_7731_(ctx.m_8083_().m_142082_(0, 1, 0), state, 3);
            ctx.m_43723_().m_21120_(ctx.m_43724_()).m_41774_(1);
            world.m_5594_(ctx.m_43723_(), ctx.m_8083_().m_142082_(0, 1, 0), SoundEvents.f_12200_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return world.m_8055_(ctx.m_8083_());
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH_FENCE});
        builder.m_61104_(new Property[]{SOUTH_FENCE});
        builder.m_61104_(new Property[]{EAST_FENCE});
        builder.m_61104_(new Property[]{WEST_FENCE});
        builder.m_61104_(new Property[]{LIFTED});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext ctx) {
        BlockState result = state;
        Vec3 relative = ctx.m_43720_().m_82492_((double)ctx.m_8083_().m_123341_(), (double)ctx.m_8083_().m_123342_(), (double)ctx.m_8083_().m_123343_());
        if (relative.f_82481_ > 0.66) {
            result = (BlockState)result.m_61124_((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)SOUTH_FENCE) == false));
        } else if (relative.f_82481_ < 0.33) {
            result = (BlockState)result.m_61124_((Property)NORTH_FENCE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)NORTH_FENCE) == false));
        }
        if (relative.f_82479_ > 0.66) {
            result = (BlockState)result.m_61124_((Property)EAST_FENCE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)EAST_FENCE) == false));
        } else if (relative.f_82479_ < 0.33) {
            result = (BlockState)result.m_61124_((Property)WEST_FENCE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)WEST_FENCE) == false));
        }
        if (result.equals(state)) {
            result = this.getRotatedBlockState(state, Direction.UP);
        }
        ctx.m_43725_().m_7731_(ctx.m_8083_(), result, 3);
        return InteractionResult.SUCCESS;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.m_122434_() == Direction.Axis.Y) {
            int state = ((Boolean)originalState.m_61143_((Property)NORTH_FENCE) != false ? 8 : 0) + ((Boolean)originalState.m_61143_((Property)EAST_FENCE) != false ? 4 : 0) + ((Boolean)originalState.m_61143_((Property)SOUTH_FENCE) != false ? 2 : 0) + ((Boolean)originalState.m_61143_((Property)WEST_FENCE) != false ? 1 : 0);
            return (BlockState)((BlockState)((BlockState)((BlockState)originalState.m_61124_((Property)NORTH_FENCE, (Comparable)Boolean.valueOf((state & 1) == 1))).m_61124_((Property)EAST_FENCE, (Comparable)Boolean.valueOf((state & 8) == 8))).m_61124_((Property)SOUTH_FENCE, (Comparable)Boolean.valueOf((state & 4) == 4))).m_61124_((Property)WEST_FENCE, (Comparable)Boolean.valueOf((state & 2) == 2));
        }
        return originalState;
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && fluid == Fluids.f_76193_;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (CatwalkBlock.isCatwalk(neighbor.m_60734_())) {
            state = (BlockState)state.m_61124_((Property)CatwalkBlock.getPropertyFromDirection(dir), (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public static boolean isCatwalk(ItemStack test) {
        return test.m_41720_() instanceof BlockItem && CatwalkBlock.isCatwalk(((BlockItem)test.m_41720_()).m_40614_());
    }

    public static boolean isCatwalk(Block test) {
        return test instanceof CatwalkBlock;
    }

    public static boolean canPlaceCatwalk(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60767_().m_76336_();
    }

    public static BooleanProperty getPropertyFromDirection(Direction dir) {
        switch (dir) {
            case NORTH: {
                return NORTH_FENCE;
            }
            case SOUTH: {
                return SOUTH_FENCE;
            }
            case EAST: {
                return EAST_FENCE;
            }
            case WEST: {
                return WEST_FENCE;
            }
        }
        return LIFTED;
    }
}

